using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Greg Lohse</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>09/22/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// LockManager data access layer class.
	///</summary>

	#endregion
	
	public class LockManager
	{	

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6817"> 
		///		<ExpectedInput>RecordGuid, FormInstanceGuid, LockFunction</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6818"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Locks the incoming record
		/// </summary>
		/// <param name="recordGuid"></param>
        /// <param name="lockedFormId"></param>
		/// <param name="lockFunction"></param>
		/// <param name="multiDivisionIndicator"></param>
        /// <param name="baseLockedFormId">baseform property</param>
        /// <param name="lockInactivityTimeoutMin"></param>
		public static DataTable LockRecord(System.Guid recordGuid, int lockedFormId, Common.LockFunctions lockFunction, bool multiDivisionIndicator, int baseLockedFormId, int lockInactivityTimeoutMin)
		{
            //CR3311 lockInactivityTimeoutMin added
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.InsertVbecsLock.lockedrecordguid, System.Data.DbType.Guid),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lockedformid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lockfunctionid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lastupdateuser,System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lastupdatefunctionid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.divisioncode, System.Data.SqlDbType.VarChar),
                new SqlParameter(STOREDPROC.InsertVbecsLock.lockinactivitytimeoutmin, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.sessionguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.InsertVbecsLock.multidivisionindicator, System.Data.SqlDbType.Bit),
                new SqlParameter(STOREDPROC.InsertVbecsLock.baselockedformid, System.Data.SqlDbType.Int),
			};

            prms[0].Value = (recordGuid == System.Guid.Empty) ? (object)DBNull.Value : (object)recordGuid;
			prms[1].Value = lockedFormId;
			prms[2].Value = (int)lockFunction;
			prms[3].Value = Common.LogonUser.LogonUserName;
			prms[4].Value = (int)Common.UpdateFunction.LockingFunction;
			prms[5].Value = (Common.LogonUser.LogonUserDivisionCode == null) ? (object)DBNull.Value : (object)Common.LogonUser.LogonUserDivisionCode;
		    prms[6].Value = lockInactivityTimeoutMin;
			prms[7].Value = Common.LogonUser.VbecsSessionGuid;
			prms[8].Value = multiDivisionIndicator;
            prms[9].Value = baseLockedFormId;

            return Common.StoredProcedure.GetDataTable(STOREDPROC.InsertVbecsLock.StoredProcName, prms);
		}

        /// <summary>
        /// Locks the incoming use case
        /// </summary>
        /// <param name="lockedRecordGuid"></param>
        /// <param name="lockedUseCaseId"></param>
        /// <param name="lockedFormId"></param>
        /// <param name="lockFunction"></param>
        /// <param name="multiDivisionIndicator"></param>
        /// <param name="baseLockedFormId">baseform property</param>
        /// <param name="lockInactivityTimeoutMin"></param>
        public static DataTable LockUseCase(Guid lockedRecordGuid, int lockedUseCaseId, int lockedFormId, Common.LockFunctions lockFunction, bool multiDivisionIndicator, int baseLockedFormId, int lockInactivityTimeoutMin)
        {
            //CR3311 lockInactivityTimeoutMin added
            SqlParameter[] prms =
			{
                new SqlParameter(STOREDPROC.InsertVbecsLock.lockedusecaseid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lockedformid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lockfunctionid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lastupdateuser,System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.InsertVbecsLock.lastupdatefunctionid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.InsertVbecsLock.divisioncode, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.InsertVbecsLock.sessionguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.InsertVbecsLock.multidivisionindicator, System.Data.SqlDbType.Bit),
                new SqlParameter(STOREDPROC.InsertVbecsLock.baselockedformid, System.Data.SqlDbType.Int),
                new SqlParameter(STOREDPROC.InsertVbecsLock.lockinactivitytimeoutmin, System.Data.SqlDbType.Int),
                new SqlParameter(STOREDPROC.InsertVbecsLock.lockedrecordguid, System.Data.SqlDbType.UniqueIdentifier)
			};

            prms[0].Value = (lockedUseCaseId == int.MinValue) ? (object)DBNull.Value : (object)lockedUseCaseId;
            prms[1].Value = lockedFormId;
            prms[2].Value = (int)lockFunction;
            prms[3].Value = Common.LogonUser.LogonUserName;
            prms[4].Value = (int)Common.UpdateFunction.LockingFunction;
            prms[5].Value = (Common.LogonUser.LogonUserDivisionCode == null) ? (object)DBNull.Value : (object)Common.LogonUser.LogonUserDivisionCode;
            prms[6].Value = Common.LogonUser.VbecsSessionGuid;
            prms[7].Value = multiDivisionIndicator;
            prms[8].Value = baseLockedFormId;
            prms[9].Value = lockInactivityTimeoutMin;
            prms[10].Value = (lockedRecordGuid == System.Guid.Empty) ? (object)DBNull.Value : (object)lockedRecordGuid;
            

            return Common.StoredProcedure.GetDataTable(STOREDPROC.InsertVbecsLock.StoredProcName, prms);
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/3/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6821"> 
		///		<ExpectedInput>UserName LockFunction</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6822"> 
		///		<ExpectedInput>Undefined User</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// NEW
		/// </summary>
		/// <param name="userName"></param>
		/// <param name="lockFunction"></param>
        /// <param name="LockedFormId"></param>
        /// <param name="BaseLockedFormId">baseformm property</param>
		public static void UnlockAllRecordsForUseCaseUser(string userName, Common.LockFunctions lockFunction, int LockedFormId, int BaseLockedFormId)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.DeleteVbecsLock.lockfunctionid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.DeleteVbecsLock.lastupdateuser, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.DeleteVbecsLock.lockedformid, System.Data.SqlDbType.Int),
				new SqlParameter(STOREDPROC.DeleteVbecsLock.divisioncode, System.Data.SqlDbType.Char),
				new SqlParameter(STOREDPROC.DeleteVbecsLock.sessionguid, System.Data.SqlDbType.UniqueIdentifier),
                new SqlParameter(STOREDPROC.DeleteVbecsLock.baselockedformid, System.Data.SqlDbType.Int)
			};
			
			prms[0].Value = (int)lockFunction;
			prms[1].Value = Common.LogonUser.LogonUserName;
			prms[2].Value = LockedFormId;
			if (gov.va.med.vbecs.Common.LogonUser.NotDefined)
			{
				prms[3].Value = DBNull.Value;
			}
			else
			{
				prms[3].Value = Common.LogonUser.LogonUserDivisionCode;
			}

			prms[4].Value = Common.LogonUser.VbecsSessionGuid;
            prms[5].Value = BaseLockedFormId;

			new StoredProcedure().TransactionalGetValue(STOREDPROC.DeleteVbecsLock.StoredProcName, prms);
		}

        /// <summary>
        /// LOCKING420 - Rewrite to replace other UnlockRecords method
        /// </summary>
        /// <param name="lockedRecordGuids"></param>
        /// <param name="LockedFormId"></param>
        /// <param name="lockFunction"></param>
        public static void UnlockRecords(System.Collections.ArrayList lockedRecordGuids, int LockedFormId, Common.LockFunctions lockFunction)
        {
            System.Data.DataTable dtLocks = new System.Data.DataTable();

            //Column names that correspond to the spInsertLock parameter list
            dtLocks.Columns.Add(TABLES.VbecsLock.LockedRecordGuid, typeof(System.Guid));
            dtLocks.Columns.Add(TABLES.VbecsLock.LockedFormId, typeof(int));
            dtLocks.Columns.Add(TABLES.VbecsLock.LockFunctionId, typeof(int));
            dtLocks.Columns.Add(TABLES.VbecsLock.LastUpdateUser, typeof(string));
            dtLocks.Columns.Add(TABLES.VbecsLock.DivisionCode, typeof(string));
            dtLocks.Columns.Add(TABLES.VbecsLock.SessionGuid, typeof(System.Guid));

            //Create a new row in the table for each Record we want locked
            foreach (System.Guid recordGuid in lockedRecordGuids)
            {
                System.Data.DataRow drAdd = dtLocks.NewRow();
                drAdd[TABLES.VbecsLock.LockedRecordGuid] = recordGuid;
                drAdd[TABLES.VbecsLock.LockedFormId] = LockedFormId;
                drAdd[TABLES.VbecsLock.LockFunctionId] = (int)lockFunction;
                drAdd[TABLES.VbecsLock.LastUpdateUser] = Common.LogonUser.LogonUserName;

                if (Common.LogonUser.LogonUserDivisionCode != null)
                {
                    drAdd[TABLES.VbecsLock.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
                }

                drAdd[TABLES.VbecsLock.SessionGuid] = Common.LogonUser.VbecsSessionGuid;

                dtLocks.Rows.Add(drAdd);
            }

            new Common.StoredProcedure().TransactionalGetValue(STOREDPROC.DeleteVbecsLock.StoredProcName, dtLocks);
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/20/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1192"> 
		///		<ExpectedInput>RecordGuids, LockFunctions Id</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1193"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Unlock multiple records in a transaction
		/// </summary>
		/// <param name="recordGuids"></param>
        /// <param name="LockedFormId"></param>
		/// <param name="lockFunction"></param>
		public static void UnlockRecords(System.Guid[] recordGuids, int LockedFormId, Common.LockFunctions lockFunction)
		{
			System.Data.DataTable dtLocks = new System.Data.DataTable();
			
			//Column names that correspond to the spInsertLock parameter list
			dtLocks.Columns.Add(TABLES.VbecsLock.LockedRecordGuid, typeof(System.Guid));
			dtLocks.Columns.Add(TABLES.VbecsLock.LockedFormId, typeof(Int16));
            dtLocks.Columns.Add(TABLES.VbecsLock.LockFunctionId, typeof(Int16));
			dtLocks.Columns.Add(TABLES.VbecsLock.LastUpdateUser, typeof(string));
			dtLocks.Columns.Add(TABLES.VbecsLock.DivisionCode, typeof(string));
			dtLocks.Columns.Add(TABLES.VbecsLock.SessionGuid, typeof(System.Guid));

			//Create a new row in the table for each Record we want locked
			foreach(System.Guid recordGuid in recordGuids)
			{
				System.Data.DataRow drAdd = dtLocks.NewRow();
				drAdd[TABLES.VbecsLock.LockedRecordGuid] = recordGuid;
				drAdd[TABLES.VbecsLock.LockedFormId] = LockedFormId;
				drAdd[TABLES.VbecsLock.LockFunctionId] = (int)lockFunction;
				drAdd[TABLES.VbecsLock.LastUpdateUser] = Common.LogonUser.LogonUserName;
				
				if (Common.LogonUser.LogonUserDivisionCode != null)
				{
					drAdd[TABLES.VbecsLock.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
				}
				
				drAdd[TABLES.VbecsLock.SessionGuid] = Common.LogonUser.VbecsSessionGuid;

				dtLocks.Rows.Add(drAdd);
			}

			new Common.StoredProcedure().TransactionalGetValue(STOREDPROC.DeleteVbecsLock.StoredProcName, dtLocks);
		}

        ///<Developers>
        ///	<Developer>Greg Lohse</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>3/3/2005</CreationDate>
        ///<TestCases>
        ///	
        ///<Case type="0" testid ="6819"> 
        ///		<ExpectedInput>RecordGuid</ExpectedInput>
        ///		<ExpectedOutput>DataTable</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///<Case type="1" testid ="6820"> 
        ///		<ExpectedInput>Invalid RecordGuid</ExpectedInput>
        ///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
        ///	</Case>
        ///
        ///
        ///</TestCases>
        ///<Update></Update>
        ///<ArchivePlan></ArchivePlan>
        ///<Interfaces></Interfaces>
        ///
        /// <summary>
        /// Returns table for Locked record.  (record(s)? - hopefully not)
        /// </summary>
        /// <param name="recordGuid"></param>
        /// <returns></returns>
        public static System.Data.DataTable GetLock(System.Guid recordGuid)
        {
            //CR3311 - sproc renamed from GetLock to GetVbecsLock
            SqlParameter[] prms =
				{
					new SqlParameter(STOREDPROC.GetVbecsLock.recordguid, System.Data.DbType.Guid),
					new SqlParameter(STOREDPROC.GetVbecsLock.divisioncode, System.Data.SqlDbType.VarChar)
				};

            prms[0].Value = recordGuid;
            prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

            return Common.StoredProcedure.GetDataTable(STOREDPROC.GetVbecsLock.StoredProcName, prms);
        }

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/20/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1194"> 
		///		<ExpectedInput>UserName</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///	
		///<Case type="1" testid ="1195"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Deletes all records from the VbecsLock table for a particular user
		/// </summary>
		/// <param name="userName"></param>
		/// <param name="unlockAllSessions"></param>
		public static void UnlockAllRecordsForUser(string userName, bool unlockAllSessions)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.DeleteAllVbecsLocksForUser.lastupdateuser, System.Data.SqlDbType.VarChar),
				new SqlParameter(STOREDPROC.DeleteAllVbecsLocksForUser.sessionguid, System.Data.SqlDbType.UniqueIdentifier)
			};
			
			prms[0].Value = userName;
			prms[1].Value = unlockAllSessions ? (object)DBNull.Value : (object)Common.LogonUser.VbecsSessionGuid;

			new StoredProcedure().TransactionalGetValue(STOREDPROC.DeleteAllVbecsLocksForUser.StoredProcName, prms);
		}

	}
}
